IF OBJECT_ID('P_EXP_CTB_MOV_CNT_CTB_FILIAIS') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_CNT_CTB_FILIAIS
	END

GO
 
CREATE PROCEDURE [dbo].[P_EXP_CTB_MOV_CNT_CTB_FILIAIS]		
WITH ENCRYPTION AS  

BEGIN 

	------------------------------------------------------------------------------------------------------------------------------
	--ATUALIZANDO CONTAS CONTABEIS DAS FILIAIS E LANCAMENTO NO CENTRO DE CUSTO DA TABELA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------	
	UPDATE MOV SET 
		CD_CNT_RED_CREDITO	= (CASE WHEN TP_TRANSA = 'C' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_CREDITO,0) = 0) THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_CREDITO		= (CASE WHEN TP_TRANSA = 'C' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_CREDITO,'') = '')   THEN ISNULL(CNT_CTB.CD_CTB_CNT,'')		ELSE '' END),
		CD_CNT_RED_DEBITO	= (CASE WHEN TP_TRANSA = 'D' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_DEBITO,0) = 0)  THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_DEBITO		= (CASE WHEN TP_TRANSA = 'D' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_DEBITO,'') = '')    THEN ISNULL(CNT_CTB.CD_CTB_CNT,'')		ELSE '' END),		
		
		DS_CENTRO_CUSTO		= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.DS_CENTRO_CTB	ELSE '' END),
		CNT_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.CNT_CENTRO_CTB ELSE 0 END),
		VLR_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN MOV.VLR_LANC					ELSE 0 END),
		RATEIO_CENTRO_CUSTO = (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN 1								ELSE 0 END),
		CD_CENTRO_CTB_REDU  = (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0  THEN CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU ELSE 0 END)								
		
	FROM ##CTB_EXP_MOV MOV 
		INNER JOIN PRC_FILIAL_CNT_CTB CNT_CTB ON
			MOV.CD_EMP		= CNT_CTB.CD_EMP AND
			MOV.CD_FILIAL	= CNT_CTB.CD_FILIAL AND 
			MOV.COD_CONTA   = CNT_CTB.TP_CNT_CTB
		LEFT JOIN CTB_CENTRO_CUSTO ON
			CNT_CTB.CD_EMP			= CTB_CENTRO_CUSTO.CD_EMP AND
			CNT_CTB.CD_CENTRO_CTB	= CTB_CENTRO_CUSTO.CD_CENTRO_CTB
			
	WHERE 
		MOV.ORIG_CONTA = 'FILIAIS';

	------------------------------------------------------------------------------------------------------------------------------
	--ATUALIZANDO CONTAS CONTABEIS DA MATRIZ E LANCAMENTO NO CENTRO DE CUSTO DA TABELA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------	 
		UPDATE MOV
		  SET
			  CD_CNT_RED_CREDITO = (CASE
										WHEN MOV.TP_TRANSA = 'C'
											 OR (MOV.TP_TRANSA = 'A'
												 AND ISNULL(MOV.CD_CNT_RED_CREDITO, 0) = 0) THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED, 0)
										ELSE 0
									END)
			, CD_CNT_CREDITO = (CASE
									WHEN MOV.TP_TRANSA = 'C'
										 OR (MOV.TP_TRANSA = 'A'
											 AND ISNULL(MOV.CD_CNT_CREDITO, '') = '') THEN ISNULL(CNT_CTB.CD_CTB_CNT, '')
									ELSE ''
								END)
			, CD_CNT_RED_DEBITO = (CASE
									   WHEN MOV.TP_TRANSA = 'D'
											OR (MOV.TP_TRANSA = 'A'
												AND ISNULL(MOV.CD_CNT_RED_DEBITO, 0) = 0) THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED, 0)
									   ELSE 0
								   END)
			
			
			, CD_CNT_DEBITO = (CASE WHEN MOV.TP_TRANSA = 'D' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_DEBITO, '') = '') THEN ISNULL(CNT_CTB.CD_CTB_CNT, '')
								   ELSE ''
							   END)


			, DS_CENTRO_CUSTO = (CASE
									 WHEN CNT_CTB.CD_CENTRO_CTB > 0
										  AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.DS_CENTRO_CTB
									 ELSE ''
								 END)
			, CNT_CENTRO_CUSTO = (CASE
									  WHEN CNT_CTB.CD_CENTRO_CTB > 0
										   AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.CNT_CENTRO_CTB
									  ELSE 0
								  END)
			, VLR_CENTRO_CUSTO = (CASE
									  WHEN CNT_CTB.CD_CENTRO_CTB > 0
										   AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN MOV.VLR_LANC
									  ELSE 0
								  END)
			, RATEIO_CENTRO_CUSTO = (CASE
										 WHEN CNT_CTB.CD_CENTRO_CTB > 0
											  AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN 1
										 ELSE 0
									 END)
			, CD_CENTRO_CTB_REDU = (CASE
										WHEN CNT_CTB.CD_CENTRO_CTB > 0 THEN CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
										ELSE 0
									END)
		FROM   ##CTB_EXP_MOV MOV
			   INNER JOIN PRC_FILIAL_CNT_CTB CNT_CTB ON MOV.CD_EMP = CNT_CTB.CD_EMP
														AND MOV.COD_CONTA = CNT_CTB.TP_CNT_CTB
			   LEFT JOIN CTB_CENTRO_CUSTO ON CNT_CTB.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP
											 AND CNT_CTB.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
		WHERE
			  MOV.ORIG_CONTA = 'MATRIZ'
			  AND CNT_CTB.CD_FILIAL IN(SELECT F.CD_FILIAL FROM PRC_FILIAL F WHERE  F.FILIAL_MTZ = 1);
		 
	--------------------------------------------------------------------------------------------------------------------------------------------
	--ATUALIZANDO CONTAS CONTABEIS NO CENTRO DE CUSTO DA TABELA ##CTB_EXP_MOV - inserido aki p/ nao inserir em cada funao
	--------------------------------------------------------------------------------------------------------------------------------------------	
	UPDATE MOV 
	SET  
		CD_CENTRO_CTB_REDU  = ISNULL(CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU,  0 )								
		
	FROM ##CTB_EXP_MOV MOV  
		INNER JOIN CTB_CENTRO_CUSTO ON
			MOV.CD_EMP			= CTB_CENTRO_CUSTO.CD_EMP AND  -- SELECT * FROM CTB_CENTRO_CUSTO
			MOV.CNT_CENTRO_CUSTO = CTB_CENTRO_CUSTO.CNT_CENTRO_CTB
	 			
	    WHERE 
		    --MOV.ORIG_CONTA = 'DESPESAS'
		     CTB_CENTRO_CUSTO.CNT_CENTRO_CTB = MOV.CNT_CENTRO_CUSTO
		    AND MOV.CNT_CENTRO_CUSTO <> ''
			 
	   
END
